/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.media.video;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.IFrameView;
import io.dcloud.common.DHInterface.ISysEventListener;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.ui.AdaFrameItem;
import io.dcloud.common.adapter.util.ViewOptions;
import io.dcloud.common.util.JSONUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.media.video.VideoPlayerMgr;
import io.dcloud.media.video.ijkplayer.VideoPlayerView;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DHVideoFrameItem
extends AdaFrameItem
implements ISysEventListener {
    private IWebview mIWebview;
    private VideoPlayerView mPlayerView;
    private String mId;
    private long resumeTime = 0L;
    private String userId;
    private IWebview mAppendWebview = null;
    public String position = "static";
    private ViewGroup.LayoutParams _vlps;
    private IWebview mContenterView = null;
    private JSONArray rect = null;
    private JSONObject styles = null;
    private boolean isRegisterResize = false;

    public void removeFrameItem() {
        if (this.position.equals("absolute")) {
            this.mContenterView.obtainFrameView().removeFrameItem((AdaFrameItem)this);
        } else {
            this.mContenterView.removeFrameItem((AdaFrameItem)this);
        }
    }

    protected DHVideoFrameItem(Context pContext, String id, IWebview pWebview, JSONArray rectJa, JSONObject style, String userId) {
        super(pContext);
        this.mIWebview = pWebview;
        this.mContenterView = pWebview;
        this.mId = id;
        this.userId = userId;
        this.rect = rectJa;
        this.styles = style;
        IApp app = this.mIWebview.obtainFrameView().obtainApp();
        app.registerSysEventListener((ISysEventListener)this, ISysEventListener.SysEventType.onPause);
        app.registerSysEventListener((ISysEventListener)this, ISysEventListener.SysEventType.onResume);
        app.registerSysEventListener((ISysEventListener)this, ISysEventListener.SysEventType.onStop);
        app.registerSysEventListener((ISysEventListener)this, ISysEventListener.SysEventType.onKeyUp);
        this.mPlayerView = new VideoPlayerView(this.mIWebview.getActivity(), pWebview, this.styles);
        this.setMainView((View)this.mPlayerView);
        this.initFrame(this.rect);
        this.position = this.styles.optString("position");
    }

    private void initFrame(JSONArray rect) {
        ViewGroup.LayoutParams _lp;
        AdaFrameItem frameView = (AdaFrameItem)this.mContenterView.obtainFrameView();
        ViewOptions webParentViewRect = frameView.obtainFrameOptions();
        float scale = this.mContenterView.getScale();
        int _w = PdrUtil.convertToScreenInt((String)JSONUtil.getString((JSONArray)rect, (int)2), (int)webParentViewRect.width, (int)webParentViewRect.width, (float)scale, (boolean)true);
        int _h = PdrUtil.convertToScreenInt((String)JSONUtil.getString((JSONArray)rect, (int)3), (int)webParentViewRect.height, (int)webParentViewRect.height, (float)scale, (boolean)true);
        int _l = PdrUtil.convertToScreenInt((String)JSONUtil.getString((JSONArray)rect, (int)0), (int)webParentViewRect.width, (int)0, (float)scale, (boolean)true);
        int _t = PdrUtil.convertToScreenInt((String)JSONUtil.getString((JSONArray)rect, (int)1), (int)webParentViewRect.height, (int)0, (float)scale, (boolean)true);
        this.updateViewRect((AdaFrameItem)this.mContenterView.obtainFrameView(), new int[]{_l, _t, _w, _h}, new int[]{webParentViewRect.width, webParentViewRect.height});
        this._vlps = _lp = AdaFrameItem.LayoutParamsUtil.createLayoutParams((int)_l, (int)_t, (int)_w, (int)_h);
        this.mPlayerView.setRect(new int[]{_l, _t, _w + _l, _h + _t});
    }

    public String getUserId() {
        return this.userId;
    }

    public String getmId() {
        return this.mId;
    }

    public void dispose() {
        super.dispose();
        this.release();
        VideoPlayerMgr.getInstance().rmovePlayer(this.mId);
    }

    public boolean onExecute(ISysEventListener.SysEventType pEventType, Object pArgs) {
        Object[] _args;
        int keyCode;
        if (pEventType == ISysEventListener.SysEventType.onPause) {
            if (System.currentTimeMillis() - this.resumeTime > 100L) {
                this.pause();
                this.resumeTime = 0L;
            }
            return true;
        }
        if (pEventType == ISysEventListener.SysEventType.onResume) {
            if (this.resumeTime > 0L) {
                this.resume();
            }
            this.resumeTime = System.currentTimeMillis();
            return true;
        }
        if (pEventType == ISysEventListener.SysEventType.onStop) {
            this.release();
            return true;
        }
        if (pEventType == ISysEventListener.SysEventType.onKeyUp && (keyCode = ((Integer)(_args = (Object[])pArgs)[0]).intValue()) == 4 && this.isFullScreen() && this.mPlayerView != null) {
            return this.mPlayerView.onBackPressed();
        }
        return false;
    }

    public void play() {
        if (this.mPlayerView != null) {
            this.mPlayerView.play();
        }
    }

    public void pause() {
        if (this.mPlayerView != null) {
            this.mPlayerView.pause();
        }
    }

    public void resume() {
        if (this.mPlayerView != null) {
            this.mPlayerView.resume();
        }
    }

    public void seek(String position) {
        if (this.mPlayerView != null) {
            this.mPlayerView.seek(position);
        }
    }

    public void sendDanmu(JSONObject danmu) {
        if (this.mPlayerView != null) {
            this.mPlayerView.sendDanmu(danmu);
        }
    }

    public void sendPlayBackRate(String rate) {
        if (this.mPlayerView != null) {
            this.mPlayerView.playbackRate(rate);
        }
    }

    public void playbackRate(String rate) {
        if (this.mPlayerView != null) {
            this.mPlayerView.playbackRate(rate);
        }
    }

    public void requestFullScreen(String direction) {
        if (this.mPlayerView != null) {
            this.mPlayerView.requestFullScreen(direction);
        }
    }

    public void exitFullScreen() {
        if (this.mPlayerView != null) {
            this.mPlayerView.exitFullScreen();
        }
    }

    public void setOptions(JSONObject options) {
        if (this.mPlayerView != null) {
            this.styles = JSONUtil.combinJSONObject((JSONObject)this.styles, (JSONObject)options);
            if (this.mPlayerView.isFullScreen()) {
                try {
                    JSONObject fullscreenStyle = new JSONObject(this.styles.toString());
                    fullscreenStyle.remove("top");
                    fullscreenStyle.remove("left");
                    fullscreenStyle.remove("width");
                    fullscreenStyle.remove("height");
                    fullscreenStyle.remove("position");
                    this.mPlayerView.setOptions(fullscreenStyle);
                }
                catch (JSONException fullscreenStyle) {
                    // empty catch block
                }
                return;
            }
            if (options.has("top") || options.has("left") || options.has("width") || options.has("height") || options.has("position")) {
                try {
                    this.rect.put(0, (Object)JSONUtil.getString((JSONObject)options, (String)"left"));
                    this.rect.put(1, (Object)JSONUtil.getString((JSONObject)options, (String)"top"));
                    this.rect.put(2, (Object)JSONUtil.getString((JSONObject)options, (String)"width"));
                    this.rect.put(3, (Object)JSONUtil.getString((JSONObject)options, (String)"height"));
                }
                catch (JSONException fullscreenStyle) {
                    // empty catch block
                }
                String mPosition = JSONUtil.getString((JSONObject)options, (String)"position");
                this.initFrame(this.rect);
                if (options.has("position")) {
                    if (!mPosition.equals(this.position)) {
                        if ("absolute".equals(this.position)) {
                            this.mContenterView.obtainFrameView().removeFrameItem((AdaFrameItem)this);
                            this.mContenterView.addFrameItem((AdaFrameItem)this, this._vlps);
                        } else if ("static".equals(this.position)) {
                            this.mContenterView.removeFrameItem((AdaFrameItem)this);
                            this.mContenterView.obtainFrameView().addFrameItem((AdaFrameItem)this, this._vlps);
                        }
                    } else {
                        this.obtainMainView().setLayoutParams(this._vlps);
                    }
                    this.position = mPosition;
                } else {
                    this.obtainMainView().setLayoutParams(this._vlps);
                }
            }
            this.mPlayerView.setOptions(this.styles);
        }
    }

    public void addEventListener(String event, String callbackId, String webId) {
        if (this.mPlayerView != null) {
            this.mPlayerView.addEventListener(event, callbackId, webId);
        }
    }

    public void release() {
        if (this.mPlayerView != null) {
            this.mPlayerView.release();
            this.mPlayerView = null;
        }
    }

    public boolean isFullScreen() {
        if (this.mPlayerView != null) {
            return this.mPlayerView.isFullScreen();
        }
        return false;
    }

    public void stop() {
        if (this.mPlayerView != null) {
            this.mPlayerView.stop();
        }
    }

    public void close() {
        if (this.mPlayerView != null) {
            this.mPlayerView.close();
        }
    }

    public void hidden() {
        if (this.mPlayerView != null) {
            this.mPlayerView.setVisibility(4);
        }
    }

    public void show() {
        if (this.mPlayerView != null) {
            this.mPlayerView.setVisibility(0);
        }
    }

    public void appendToFrame(IFrameView mFrameView) {
        View mainView = this.obtainMainView();
        if (mainView != null && mainView.getParent() != null) {
            this.removeFrameItem();
        }
        this.mContenterView = mFrameView.obtainWebView();
        this.initFrame(this.rect);
        if (this.position.equals("static")) {
            this.mContenterView.addFrameItem((AdaFrameItem)this, this._vlps);
        } else if (this.position.equals("absolute")) {
            this.mContenterView.obtainFrameView().addFrameItem((AdaFrameItem)this, this._vlps);
        } else {
            this.mContenterView.addFrameItem((AdaFrameItem)this, this._vlps);
        }
    }

    protected void onResize() {
        if (this.isRegisterResize) {
            return;
        }
        super.onResize();
        this.initFrame(this.rect);
        this.obtainMainView().setLayoutParams(this._vlps);
    }

    public void resize(JSONArray pJsArgs) {
        this.initFrame(pJsArgs);
        this.obtainMainView().setLayoutParams(this._vlps);
        this.isRegisterResize = true;
    }
}

