/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.common.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import io.dcloud.common.DHInterface.IActivityDelegate;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.adapter.util.AndroidResources;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.adapter.util.MobilePhoneModel;
import io.dcloud.common.adapter.util.PlatformUtil;
import io.dcloud.common.core.ui.DCKeyboardManager;
import io.dcloud.common.util.Base64;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.p.b5;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import org.json.JSONObject;

public class AppStatusBarManager {
    private int mStatusBarDefaultColor = 0;
    public boolean isImmersive = false;
    public boolean isFullScreen = false;
    public boolean isHandledWhiteScreen = false;
    public boolean isTemporaryFullScreen = true;
    private b5 mWebAppInfo;
    private IApp mIApp;

    public AppStatusBarManager(Activity activity, b5 b52) {
        this.initStatusBarDefaultColor(activity);
        this.mWebAppInfo = b52;
        this.mIApp = (IApp)((Object)b52);
        this.initDirectImmersive();
    }

    private void initDirectImmersive() {
        if (this.mWebAppInfo.getActivity().getIntent().hasExtra("direct_page") && BaseInfo.isWap2AppAppid(this.mWebAppInfo.o)) {
            if (Build.VERSION.SDK_INT > 19) {
                AppStatusBarManager appStatusBarManager = this;
                JSONObject jSONObject = appStatusBarManager.getDirectStatusJson(appStatusBarManager.mIApp);
                this.isImmersive = jSONObject != null && jSONObject.has("immersed") ? jSONObject.optBoolean("immersed") : true;
                BaseInfo.isImmersive = this.isImmersive;
                return;
            }
            return;
        }
    }

    private void initStatusBarDefaultColor(Activity activity) {
        if (activity != null && Build.VERSION.SDK_INT >= 21) {
            activity = activity.getWindow();
            int n5 = this.getStatusbarColorIndex();
            if (n5 > 0) {
                this.mStatusBarDefaultColor = activity.getWindowStyle().getColor(n5, 0);
            }
            if (this.mStatusBarDefaultColor == 0) {
                this.mStatusBarDefaultColor = Color.parseColor((String)"#D4D4D4");
                return;
            }
        }
    }

    private void diyContentFullScreenBug(Activity activity) {
        block6: {
            block5: {
                FrameLayout frameLayout = null;
                if (activity instanceof IActivityDelegate) {
                    frameLayout = ((IActivityDelegate)activity).obtainActivityContentView();
                }
                if (frameLayout == null) break block5;
                if (!((AppStatusBarManager)((Object)string2)).isFullScreen && !((AppStatusBarManager)((Object)string2)).isImmersive) {
                    ((AppStatusBarManager)((Object)string2)).isTemporaryFullScreen = false;
                    DCKeyboardManager.getInstance().setAdjust(false);
                    return;
                }
                String string2 = AndroidResources.getMetaValue("DCLOUD_INPUT_MODE");
                if (TextUtils.isEmpty((CharSequence)string2) || !string2.contains("adjustPan")) break block6;
            }
            return;
        }
        DCKeyboardManager.getInstance().setAdjust(true);
    }

    @TargetApi(value=19)
    private void setTranslucentStatus(final Activity activity, boolean bl) {
        Window window = activity.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        layoutParams.flags = bl ? (layoutParams.flags |= 0x4000000) : (layoutParams.flags &= 0xFBFFFFFF);
        Window window2 = window;
        window2.setAttributes(layoutParams);
        window2.getDecorView().post(new Runnable(){

            @Override
            public void run() {
                2 this_ = this_.AppStatusBarManager.this.getRootView(this_.activity);
                if (this_.getParent() instanceof LinearLayout) {
                    LinearLayout.LayoutParams layoutParams;
                    2 v02 = this_;
                    this_ = layoutParams;
                    layoutParams = new LinearLayout.LayoutParams(-1, -1);
                    v02.setLayoutParams((ViewGroup.LayoutParams)this_);
                    return;
                }
                if (this_.getParent() instanceof FrameLayout) {
                    FrameLayout.LayoutParams layoutParams;
                    2 v22 = this_;
                    this_ = layoutParams;
                    layoutParams = new FrameLayout.LayoutParams(-1, -1);
                    v22.setLayoutParams((ViewGroup.LayoutParams)this_);
                    return;
                }
            }
        });
    }

    private View getRootView(Activity activity) {
        return activity.findViewById(0x1020002);
    }

    private void setMeizuStatusBarDarkIcon(Activity activity, boolean bl) {
        if (activity != null) {
            boolean bl2;
            try {
                bl2 = bl;
                AppStatusBarManager appStatusBarManager = activity.getWindow().getAttributes();
            }
            catch (Exception exception) {}
            Field field = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
            Field field2 = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
            AppStatusBarManager appStatusBarManager = appStatusBarManager;
            ((AccessibleObject)field).setAccessible(true);
            ((AccessibleObject)field2).setAccessible(true);
            int n5 = field.getInt(null);
            int n6 = field2.getInt(appStatusBarManager);
            n5 = bl2 ? n6 | n5 : n6 & ~n5;
            field2.setInt(appStatusBarManager, n5);
            activity.getWindow().setAttributes((WindowManager.LayoutParams)appStatusBarManager);
            return;
        }
    }

    private void setMiuiStatusBarDarkMode(Activity object, boolean bl) {
        Activity activity = object;
        try {
            Class<?> clazz = Class.forName("android.view.MiuiWindowManager$LayoutParams");
        }
        catch (Exception exception) {
            return;
        }
        int n5 = clazz.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE").getInt(clazz);
        String string2 = "setExtraFlags";
        Class[] classArray = new Class[2];
        Class[] classArray2 = classArray;
        Class[] classArray3 = classArray;
        Class[] classArray4 = classArray;
        object = Integer.TYPE;
        classArray3[0] = object;
        classArray4[1] = object;
        object = activity.getWindow().getClass().getMethod(string2, classArray2);
        Window window = activity.getWindow();
        int n6 = bl ? n5 : 0;
        Activity activity2 = object;
        int n7 = n5;
        Integer n8 = n6;
        object = n7;
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n8;
        objectArray[1] = object;
        activity2.invoke((Object)window, objectArray2);
    }

    public int getStatusBarDefaultColor() {
        return this.mStatusBarDefaultColor;
    }

    public int getStatusbarColorIndex() {
        try {
            Object object = PlatformUtil.newInstance(Base64.decode2String("Y29tLmFuZHJvaWQuaW50ZXJuYWwuUiRzdHlsZWFibGU="), null, null);
        }
        catch (Exception exception) {
            return -1;
        }
        return Integer.parseInt(PlatformUtil.invokeFieldValue(null, "Window_statusBarColor", object).toString());
    }

    public void setImmersive(final Activity activity, boolean bl) {
        if (activity != null) {
            int n5 = Build.VERSION.SDK_INT;
            if (!(n5 == 19 || DeviceInfo.sBrand.equalsIgnoreCase(MobilePhoneModel.SONY) && n5 >= 21 || DeviceInfo.sBrand.equalsIgnoreCase(MobilePhoneModel.QiKU) && n5 >= 21)) {
                if (n5 >= 21) {
                    this.isImmersive = bl;
                    Window window = activity.getWindow();
                    n5 = window.getDecorView().getSystemUiVisibility();
                    window.clearFlags(1024);
                    if (bl) {
                        Window window2 = window;
                        Window window3 = window;
                        window3.clearFlags(0x4000000);
                        window3.addFlags(Integer.MIN_VALUE);
                        window2.getDecorView().setSystemUiVisibility(n5 |= 0x500);
                        window2.setStatusBarColor(0);
                    } else {
                        window.getDecorView().setSystemUiVisibility(n5 &= 0xFFFFFAFF);
                        window.setStatusBarColor(this.mStatusBarDefaultColor);
                    }
                    window.getDecorView().post(new Runnable(){

                        @Override
                        public void run() {
                            1 this_ = this_.AppStatusBarManager.this.getRootView(this_.activity);
                            if (this_.getParent() instanceof LinearLayout) {
                                LinearLayout.LayoutParams layoutParams;
                                1 v02 = this_;
                                this_ = layoutParams;
                                layoutParams = new LinearLayout.LayoutParams(-1, -1);
                                v02.setLayoutParams((ViewGroup.LayoutParams)this_);
                                return;
                            }
                            if (this_.getParent() instanceof FrameLayout) {
                                FrameLayout.LayoutParams layoutParams;
                                1 v22 = this_;
                                this_ = layoutParams;
                                layoutParams = new FrameLayout.LayoutParams(-1, -1);
                                v22.setLayoutParams((ViewGroup.LayoutParams)this_);
                                return;
                            }
                        }
                    });
                    this.diyContentFullScreenBug(activity);
                    return;
                }
            } else {
                AppStatusBarManager appStatusBarManager = this;
                appStatusBarManager.isImmersive = bl;
                appStatusBarManager.setTranslucentStatus(activity, bl);
                appStatusBarManager.diyContentFullScreenBug(activity);
                return;
            }
        }
    }

    public void setStatusBarMode(Activity activity, String string2) {
        int n5 = Build.VERSION.SDK_INT;
        if (n5 >= 21 && activity != null) {
            if (PdrUtil.isEmpty(string2)) {
                string2 = "nono";
            }
            boolean bl = string2.equalsIgnoreCase("dark");
            Window window = activity.getWindow();
            String string3 = Build.BRAND;
            if (string3.equalsIgnoreCase(MobilePhoneModel.GOOGLE)) {
                string3 = Build.MANUFACTURER;
            }
            if (string3.equals(MobilePhoneModel.XIAOMI)) {
                this.setMiuiStatusBarDarkMode(activity, bl);
            } else if (string3.equals(MobilePhoneModel.MEIZU)) {
                this.setMeizuStatusBarDarkIcon(activity, bl);
            }
            if (n5 >= 23) {
                int n6 = window.getDecorView().getSystemUiVisibility();
                int n7 = 8192;
                Class<?> clazz = Class.forName("android.view.View");
                try {
                    n7 = clazz.getField("SYSTEM_UI_FLAG_LIGHT_STATUS_BAR").getInt(clazz);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                n6 = bl ? (n6 |= n7) : (n6 &= ~n7);
                window.getDecorView().setSystemUiVisibility(n6);
                return;
            }
        }
    }

    public void setStatusBarColor(Activity activity, int n5) {
        if (PdrUtil.checkStatusbarColor(n5) && Build.VERSION.SDK_INT >= 21 && activity != null && !this.isImmersive) {
            Window window = activity.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(n5);
            return;
        }
    }

    public boolean isFullScreenOrImmersive() {
        return this.isImmersive || this.isFullScreen;
        {
        }
    }

    public void setFullScreen(Activity activity, boolean bl) {
        Window window = activity.getWindow();
        this.isFullScreen = bl;
        if (bl) {
            WindowManager.LayoutParams layoutParams = window.getAttributes();
            layoutParams.flags |= 0x400;
            if (Build.VERSION.SDK_INT >= 28) {
                layoutParams.layoutInDisplayCutoutMode = 1;
            }
            window.setAttributes(layoutParams);
        } else {
            WindowManager.LayoutParams layoutParams = window.getAttributes();
            layoutParams.flags &= 0xFFFFFBFF;
            if (Build.VERSION.SDK_INT >= 28) {
                layoutParams.layoutInDisplayCutoutMode = 0;
            }
            window.setAttributes(layoutParams);
        }
        this.diyContentFullScreenBug(activity);
    }

    public boolean checkImmersedStatusBar(Context context, boolean bl) {
        int n5;
        boolean bl2;
        block8: {
            bl2 = false;
            n5 = Build.VERSION.SDK_INT;
            if (n5 < 19) {
                return bl2;
            }
            context = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (context == null) break block8;
            context = context.metaData;
            if (context == null) break block8;
            try {
                bl2 = context.getBoolean("immersed.status.bar", false);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                nameNotFoundException.printStackTrace();
            }
        }
        if (bl2) {
            bl = bl2;
        }
        if (this.mWebAppInfo.n.equals("suggestedDevice") && bl) {
            bl = (DeviceInfo.sBrand.equalsIgnoreCase(MobilePhoneModel.XIAOMI) || DeviceInfo.sBrand.contentEquals(MobilePhoneModel.MEIZU)) && n5 >= 21 || n5 >= 23;
        }
        this.isImmersive = bl;
        if (!bl && this.mWebAppInfo.getActivity().getIntent().hasExtra("direct_page") && BaseInfo.isWap2AppAppid(this.mWebAppInfo.o) && !this.mIApp.manifestBeParsed()) {
            AppStatusBarManager appStatusBarManager = this;
            context = appStatusBarManager.getDirectStatusJson(appStatusBarManager.mIApp);
            this.isImmersive = context != null && context.has("immersed") ? context.optBoolean("immersed") : true;
            bl = this.isImmersive;
        }
        BaseInfo.isImmersive = this.isImmersive;
        return bl;
    }

    public JSONObject getDirectStatusJson(IApp iApp) {
        AppStatusBarManager appStatusBarManager = iApp.obtainThridInfo(IApp.ConfigProperty.ThridInfo.DirectPageJsonData);
        if (appStatusBarManager != null && appStatusBarManager.has("statusbar")) {
            if ((appStatusBarManager = appStatusBarManager.optJSONObject("statusbar")) != null) {
                return appStatusBarManager;
            }
        } else {
            appStatusBarManager = iApp.obtainThridInfo(IApp.ConfigProperty.ThridInfo.SitemapJsonData);
            if (appStatusBarManager != null && appStatusBarManager.has("statusbar")) {
                return appStatusBarManager.optJSONObject("statusbar");
            }
        }
        return null;
    }
}

