/*
 * Decompiled with CFR 0.152.
 */
package master.flame.danmaku.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import java.util.LinkedList;
import java.util.Locale;
import master.flame.danmaku.controller.DrawHandler;
import master.flame.danmaku.controller.DrawHelper;
import master.flame.danmaku.controller.IDanmakuView;
import master.flame.danmaku.controller.IDanmakuViewController;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.IDanmakus;
import master.flame.danmaku.danmaku.model.android.DanmakuContext;
import master.flame.danmaku.danmaku.parser.BaseDanmakuParser;
import master.flame.danmaku.danmaku.renderer.IRenderer;
import master.flame.danmaku.danmaku.util.SystemClock;
import master.flame.danmaku.ui.widget.DanmakuTouchHelper;

public class DanmakuSurfaceView
extends SurfaceView
implements IDanmakuView,
IDanmakuViewController,
SurfaceHolder.Callback {
    public static final String TAG = "DanmakuSurfaceView";
    private DrawHandler.Callback mCallback;
    private SurfaceHolder mSurfaceHolder;
    private HandlerThread mHandlerThread;
    private DrawHandler handler;
    private boolean isSurfaceCreated;
    private boolean mEnableDanmakuDrwaingCache = true;
    private IDanmakuView.OnDanmakuClickListener mOnDanmakuClickListener;
    private DanmakuTouchHelper mTouchHelper;
    private boolean mShowFps;
    private boolean mDanmakuVisible = true;
    protected int mDrawingThreadType = 0;
    private static final int MAX_RECORD_SIZE = 50;
    private static final int ONE_SECOND = 1000;
    private LinkedList<Long> mDrawTimes;

    public DanmakuSurfaceView(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.setZOrderMediaOverlay(true);
        this.setWillNotCacheDrawing(true);
        this.setDrawingCacheEnabled(false);
        this.setWillNotDraw(true);
        this.mSurfaceHolder = this.getHolder();
        this.mSurfaceHolder.addCallback((SurfaceHolder.Callback)this);
        this.mSurfaceHolder.setFormat(-2);
        DrawHelper.useDrawColorToClearCanvas(true, true);
        this.mTouchHelper = DanmakuTouchHelper.instance(this);
    }

    public DanmakuSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public DanmakuSurfaceView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    @Override
    public void addDanmaku(BaseDanmaku item) {
        if (this.handler != null) {
            this.handler.addDanmaku(item);
        }
    }

    @Override
    public void invalidateDanmaku(BaseDanmaku item, boolean remeasure) {
        if (this.handler != null) {
            this.handler.invalidateDanmaku(item, remeasure);
        }
    }

    @Override
    public void removeAllDanmakus(boolean isClearDanmakusOnScreen) {
        if (this.handler != null) {
            this.handler.removeAllDanmakus(isClearDanmakusOnScreen);
        }
    }

    @Override
    public void removeAllLiveDanmakus() {
        if (this.handler != null) {
            this.handler.removeAllLiveDanmakus();
        }
    }

    @Override
    public IDanmakus getCurrentVisibleDanmakus() {
        if (this.handler != null) {
            return this.handler.getCurrentVisibleDanmakus();
        }
        return null;
    }

    @Override
    public void setCallback(DrawHandler.Callback callback) {
        this.mCallback = callback;
        if (this.handler != null) {
            this.handler.setCallback(callback);
        }
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        this.isSurfaceCreated = true;
        Canvas canvas = surfaceHolder.lockCanvas();
        if (canvas != null) {
            DrawHelper.clearCanvas(canvas);
            surfaceHolder.unlockCanvasAndPost(canvas);
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        if (this.handler != null) {
            this.handler.notifyDispSizeChanged(width, height);
        }
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        this.isSurfaceCreated = false;
    }

    @Override
    public void release() {
        this.stop();
        if (this.mDrawTimes != null) {
            this.mDrawTimes.clear();
        }
    }

    @Override
    public void stop() {
        this.stopDraw();
    }

    private void stopDraw() {
        if (this.handler != null) {
            this.handler.quit();
            this.handler = null;
        }
        HandlerThread handlerThread = this.mHandlerThread;
        this.mHandlerThread = null;
        if (handlerThread != null) {
            try {
                handlerThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            handlerThread.quit();
        }
    }

    protected Looper getLooper(int type) {
        int priority;
        if (this.mHandlerThread != null) {
            this.mHandlerThread.quit();
            this.mHandlerThread = null;
        }
        switch (type) {
            case 1: {
                return Looper.getMainLooper();
            }
            case 2: {
                priority = -8;
                break;
            }
            case 3: {
                priority = 19;
                break;
            }
            default: {
                priority = 0;
            }
        }
        String threadName = "DFM Handler Thread #" + priority;
        this.mHandlerThread = new HandlerThread(threadName, priority);
        this.mHandlerThread.start();
        return this.mHandlerThread.getLooper();
    }

    private void prepare() {
        if (this.handler == null) {
            this.handler = new DrawHandler(this.getLooper(this.mDrawingThreadType), this, this.mDanmakuVisible);
        }
    }

    @Override
    public void prepare(BaseDanmakuParser parser, DanmakuContext config) {
        this.prepare();
        this.handler.setConfig(config);
        this.handler.setParser(parser);
        this.handler.setCallback(this.mCallback);
        this.handler.prepare();
    }

    @Override
    public boolean isPrepared() {
        return this.handler != null && this.handler.isPrepared();
    }

    @Override
    public DanmakuContext getConfig() {
        if (this.handler == null) {
            return null;
        }
        return this.handler.getConfig();
    }

    @Override
    public void showFPS(boolean show) {
        this.mShowFps = show;
    }

    private float fps() {
        long lastTime = SystemClock.uptimeMillis();
        this.mDrawTimes.addLast(lastTime);
        Long first = this.mDrawTimes.peekFirst();
        if (first == null) {
            return 0.0f;
        }
        float dtime = lastTime - first;
        int frames = this.mDrawTimes.size();
        if (frames > 50) {
            this.mDrawTimes.removeFirst();
        }
        return dtime > 0.0f ? (float)(this.mDrawTimes.size() * 1000) / dtime : 0.0f;
    }

    @Override
    public long drawDanmakus() {
        if (!this.isSurfaceCreated) {
            return 0L;
        }
        if (!this.isShown()) {
            return -1L;
        }
        long stime = SystemClock.uptimeMillis();
        long dtime = 0L;
        Canvas canvas = this.mSurfaceHolder.lockCanvas();
        if (canvas != null) {
            if (this.handler != null) {
                IRenderer.RenderingState rs = this.handler.draw(canvas);
                if (this.mShowFps) {
                    if (this.mDrawTimes == null) {
                        this.mDrawTimes = new LinkedList();
                    }
                    dtime = SystemClock.uptimeMillis() - stime;
                    String fps = String.format(Locale.getDefault(), "fps %.2f,time:%d s,cache:%d,miss:%d", Float.valueOf(this.fps()), this.getCurrentTime() / 1000L, rs.cacheHitCount, rs.cacheMissCount);
                    DrawHelper.drawFPS(canvas, fps);
                }
            }
            if (this.isSurfaceCreated) {
                this.mSurfaceHolder.unlockCanvasAndPost(canvas);
            }
        }
        dtime = SystemClock.uptimeMillis() - stime;
        return dtime;
    }

    @Override
    public void toggle() {
        if (this.isSurfaceCreated) {
            if (this.handler == null) {
                this.start();
            } else if (this.handler.isStop()) {
                this.resume();
            } else {
                this.pause();
            }
        }
    }

    @Override
    public void pause() {
        if (this.handler != null) {
            this.handler.pause();
        }
    }

    @Override
    public void resume() {
        if (this.handler != null && this.handler.isPrepared()) {
            this.handler.resume();
        } else if (this.handler == null) {
            this.restart();
        }
    }

    @Override
    public boolean isPaused() {
        if (this.handler != null) {
            return this.handler.isStop();
        }
        return false;
    }

    public void restart() {
        this.stop();
        this.start();
    }

    @Override
    public void start() {
        this.start(0L);
    }

    @Override
    public void start(long postion) {
        if (this.handler == null) {
            this.prepare();
        } else {
            this.handler.removeCallbacksAndMessages(null);
        }
        this.handler.obtainMessage(1, postion).sendToTarget();
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean isEventConsumed = this.mTouchHelper.onTouchEvent(event);
        if (!isEventConsumed) {
            return super.onTouchEvent(event);
        }
        return isEventConsumed;
    }

    @Override
    public void seekTo(Long ms) {
        if (this.handler != null) {
            this.handler.seekTo(ms);
        }
    }

    @Override
    public void enableDanmakuDrawingCache(boolean enable) {
        this.mEnableDanmakuDrwaingCache = enable;
    }

    @Override
    public boolean isDanmakuDrawingCacheEnabled() {
        return this.mEnableDanmakuDrwaingCache;
    }

    @Override
    public boolean isViewReady() {
        return this.isSurfaceCreated;
    }

    @Override
    public View getView() {
        return this;
    }

    @Override
    public void show() {
        this.showAndResumeDrawTask(null);
    }

    @Override
    public void showAndResumeDrawTask(Long position) {
        this.mDanmakuVisible = true;
        if (this.handler == null) {
            return;
        }
        this.handler.showDanmakus(position);
    }

    @Override
    public void hide() {
        this.mDanmakuVisible = false;
        if (this.handler == null) {
            return;
        }
        this.handler.hideDanmakus(false);
    }

    @Override
    public long hideAndPauseDrawTask() {
        this.mDanmakuVisible = false;
        if (this.handler == null) {
            return 0L;
        }
        return this.handler.hideDanmakus(true);
    }

    @Override
    public void setOnDanmakuClickListener(IDanmakuView.OnDanmakuClickListener listener) {
        this.mOnDanmakuClickListener = listener;
    }

    @Override
    public IDanmakuView.OnDanmakuClickListener getOnDanmakuClickListener() {
        return this.mOnDanmakuClickListener;
    }

    @Override
    public void clear() {
        if (!this.isViewReady()) {
            return;
        }
        Canvas canvas = this.mSurfaceHolder.lockCanvas();
        if (canvas != null) {
            DrawHelper.clearCanvas(canvas);
            this.mSurfaceHolder.unlockCanvasAndPost(canvas);
        }
    }

    @Override
    public boolean isShown() {
        return this.mDanmakuVisible && super.isShown();
    }

    @Override
    public void setDrawingThreadType(int type) {
        this.mDrawingThreadType = type;
    }

    @Override
    public long getCurrentTime() {
        if (this.handler != null) {
            return this.handler.getCurrentTime();
        }
        return 0L;
    }

    @Override
    public boolean isHardwareAccelerated() {
        return false;
    }

    @Override
    public void clearDanmakusOnScreen() {
        if (this.handler != null) {
            this.handler.clearDanmakusOnScreen();
        }
    }
}

