/*
 * Decompiled with CFR 0.152.
 */
package cn.iocoder.yudao.module.iot.service;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import cn.iocoder.yudao.module.iot.api.device.DeviceDataApi;
import cn.iocoder.yudao.module.iot.api.device.dto.DeviceDataCreateReqDTO;
import io.vertx.core.Handler;
import io.vertx.ext.web.RequestBody;
import io.vertx.ext.web.RoutingContext;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpVertxHandler
implements Handler<RoutingContext> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpVertxHandler.class);
    private final DeviceDataApi deviceDataApi;

    public HttpVertxHandler(DeviceDataApi deviceDataApi) {
        this.deviceDataApi = deviceDataApi;
    }

    public void handle(RoutingContext ctx) {
        JSONObject jsonData;
        String productKey = ctx.pathParam("productKey");
        String deviceName = ctx.pathParam("deviceName");
        RequestBody requestBody = ctx.body();
        try {
            jsonData = JSONUtil.parseObj((Object)requestBody.asJsonObject());
        }
        catch (Exception e) {
            JSONObject res = this.createResponseJson(400, new JSONObject(), null, "\u8bf7\u6c42\u6570\u636e\u4e0d\u662f\u5408\u6cd5\u7684 JSON \u683c\u5f0f: " + e.getMessage(), "thing.event.property.post", "1.0");
            ctx.response().setStatusCode(400).putHeader("Content-Type", "application/json; charset=UTF-8").end(res.toString());
            return;
        }
        String id = jsonData.getStr((Object)"id", null);
        try {
            DeviceDataCreateReqDTO createDTO = DeviceDataCreateReqDTO.builder().productKey(productKey).deviceName(deviceName).message(jsonData.toString()).build();
            this.deviceDataApi.saveDeviceData(createDTO);
            JSONObject successRes = this.createResponseJson(200, new JSONObject(), id, "success", "thing.event.property.post", "1.0");
            ctx.response().setStatusCode(200).putHeader("Content-Type", "application/json; charset=UTF-8").end(successRes.toString());
        }
        catch (Exception e) {
            JSONObject errorRes = this.createResponseJson(500, new JSONObject(), id, "The format of result is error!", "thing.event.property.post", "1.0");
            ctx.response().setStatusCode(500).putHeader("Content-Type", "application/json; charset=UTF-8").end(errorRes.toString());
        }
    }

    private JSONObject createResponseJson(int code, JSONObject data, String id, String message, String method, String version) {
        JSONObject res = new JSONObject();
        res.set("code", (Object)code);
        res.set("data", (Object)(data != null ? data : new JSONObject()));
        res.set("id", (Object)id);
        res.set("message", (Object)message);
        res.set("method", (Object)method);
        res.set("version", (Object)version);
        return res;
    }
}

