/*
 * Decompiled with CFR 0.152.
 */
package cn.iocoder.yudao.module.iot.plugin.http.config;

import cn.iocoder.yudao.module.iot.api.device.DeviceDataApi;
import cn.iocoder.yudao.module.iot.plugin.http.config.VertxService;
import cn.iocoder.yudao.module.iot.plugin.http.service.HttpVertxHandler;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.BodyHandler;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class HttpVertxPluginConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpVertxPluginConfiguration.class);
    @Value(value="${plugin.http.server.port:8092}")
    private Integer port;

    @Bean
    public Vertx vertx() {
        return Vertx.vertx();
    }

    @Bean
    public Router router(Vertx vertx, HttpVertxHandler httpVertxHandler) {
        Router router = Router.router((Vertx)vertx);
        router.route().handler((Handler)BodyHandler.create());
        router.post("/sys/:productKey/:deviceName/thing/event/property/post").handler((Handler)httpVertxHandler);
        return router;
    }

    @Bean
    public HttpVertxHandler httpVertxHandler(DeviceDataApi deviceDataApi) {
        return new HttpVertxHandler(deviceDataApi);
    }

    @Bean
    public VertxService vertxService(Vertx vertx, Router router) {
        return new VertxService(this.port, vertx, router);
    }
}

