/*
 * Decompiled with CFR 0.152.
 */
package cn.iocoder.yudao.module.iot.plugin.http.config;

import cn.hutool.extra.spring.SpringUtil;
import cn.iocoder.yudao.module.iot.api.device.DeviceDataApi;
import cn.iocoder.yudao.module.iot.plugin.http.config.VertxService;
import lombok.Generated;
import org.pf4j.PluginWrapper;
import org.pf4j.spring.SpringPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class HttpVertxPlugin
extends SpringPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpVertxPlugin.class);

    public HttpVertxPlugin(PluginWrapper pluginWrapper) {
        super(pluginWrapper);
    }

    public void start() {
        log.info("[HttpVertxPlugin] start ...");
        ApplicationContext applicationContext = this.getApplicationContext();
        if (applicationContext == null) {
            log.error("[HttpVertxPlugin] pluginContext is null, start failed.");
            return;
        }
        VertxService vertxService = (VertxService)applicationContext.getBean(VertxService.class);
        vertxService.startServer();
    }

    public void stop() {
        log.info("[HttpVertxPlugin] stop ...");
        ApplicationContext applicationContext = this.getApplicationContext();
        if (applicationContext != null) {
            VertxService vertxService = (VertxService)applicationContext.getBean(VertxService.class);
            vertxService.stopServer();
        }
    }

    protected ApplicationContext createApplicationContext() {
        AnnotationConfigApplicationContext annotationConfigApplicationContext = new AnnotationConfigApplicationContext(){

            protected void prepareRefresh() {
                ConfigurableListableBeanFactory configurableListableBeanFactory = this.getBeanFactory();
                DeviceDataApi deviceDataApi = (DeviceDataApi)SpringUtil.getBean(DeviceDataApi.class);
                configurableListableBeanFactory.registerSingleton("deviceDataApi", (Object)deviceDataApi);
                super.prepareRefresh();
            }
        };
        annotationConfigApplicationContext.setClassLoader(this.getWrapper().getPluginClassLoader());
        annotationConfigApplicationContext.scan(new String[]{"cn.iocoder.yudao.module.iot.plugin.http.config"});
        annotationConfigApplicationContext.refresh();
        return annotationConfigApplicationContext;
    }
}

