/*
 * Decompiled with CFR 0.152.
 */
package cn.iocoder.yudao.module.iot.plugin.http.upstream;

import cn.iocoder.yudao.module.iot.api.device.IotDeviceUpstreamApi;
import cn.iocoder.yudao.module.iot.plugin.http.upstream.router.IotDevicePropertyReportVertxHandler;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.BodyHandler;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IotDeviceUpstreamServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IotDeviceUpstreamServer.class);
    private final Vertx vertx;
    private final HttpServer server;
    private final Integer port;

    public IotDeviceUpstreamServer(Integer n, IotDeviceUpstreamApi iotDeviceUpstreamApi) {
        this.port = n;
        this.vertx = Vertx.vertx();
        Router router = Router.router((Vertx)this.vertx);
        router.route().handler((Handler)BodyHandler.create());
        router.post("/sys/:productKey/:deviceName/thing/event/property/post").handler((Handler)new IotDevicePropertyReportVertxHandler(iotDeviceUpstreamApi));
        this.server = this.vertx.createHttpServer().requestHandler((Handler)router);
    }

    public void start() {
        log.info("[start][\u5f00\u59cb\u542f\u52a8]");
        this.server.listen(this.port.intValue()).toCompletionStage().toCompletableFuture().join();
        log.info("[start][\u542f\u52a8\u5b8c\u6210\uff0c\u7aef\u53e3({})]", (Object)this.server.actualPort());
    }

    public void stop() {
        log.info("[stop][\u5f00\u59cb\u5173\u95ed]");
        try {
            if (this.server != null) {
                this.server.close().toCompletionStage().toCompletableFuture().join();
            }
            if (this.vertx != null) {
                this.vertx.close().toCompletionStage().toCompletableFuture().join();
            }
            log.info("[stop][\u5173\u95ed\u5b8c\u6210]");
        }
        catch (Exception exception) {
            log.error("[stop][\u5173\u95ed\u5f02\u5e38]", (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }
}

